/*
 * Decompiled with CFR 0.152.
 */
package uk101;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import uk101.machine.Computer;
import uk101.machine.Configuration;
import uk101.utils.Args;
import uk101.view.ComputerView;
import uk101.view.MachineImage;

public class Main
implements Runnable {
    private JFrame frame;
    private Computer computer;
    private ComputerView computerView;
    private boolean layout;

    public static void main(String[] args) throws Exception {
        Args.Map options = Args.optionMap();
        options.put("look", "lookAndFeel");
        options.put("c", "=configuration");
        options.put("configuration", "configFile");
        options.put("p", "=properties");
        options.put("properties", "systemProps");
        options.put("debug");
        Args parms = new Args(Main.class, "[machine]", args, options);
        Computer.debug = parms.getFlag("debug");
        String look = parms.getOption("look");
        Main.setLookAndFeel(look);
        File imageFile = parms.getInputFile(1);
        MachineImage image = null;
        Configuration imageCfg = null;
        if (imageFile != null) {
            image = MachineImage.readImage(imageFile);
            imageCfg = image.imageCfg;
        }
        Configuration config = new Configuration(parms, imageCfg);
        Computer computer = new Computer(config);
        ComputerView view = new ComputerView(computer);
        Main gui = new Main(computer, view, image);
        SwingUtilities.invokeLater(gui);
    }

    private static void setLookAndFeel(String look) throws Exception {
        UIManager.LookAndFeelInfo info;
        int n;
        int n2;
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
        String lafClass = null;
        String metalTheme = null;
        if (Computer.debug) {
            System.out.println("Look:");
            lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            n2 = lookAndFeelInfoArray.length;
            n = 0;
            while (n < n2) {
                info = lookAndFeelInfoArray[n];
                String name = info.getName();
                if (name.equals("Metal")) {
                    name = String.valueOf(name) + "/Steel/Ocean";
                }
                System.out.println("  " + name);
                ++n;
            }
        }
        if (look == null) {
            LookAndFeel laf = UIManager.getLookAndFeel();
            if (laf == null || laf.getID().equals("Metal")) {
                lafClass = UIManager.getSystemLookAndFeelClassName();
            }
        } else {
            if (look.equalsIgnoreCase("Steel") || look.equalsIgnoreCase("Ocean")) {
                metalTheme = look;
                look = "Metal";
            }
            lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            n2 = lookAndFeelInfoArray.length;
            n = 0;
            while (n < n2) {
                info = lookAndFeelInfoArray[n];
                if (info.getName().equalsIgnoreCase(look)) {
                    lafClass = info.getClassName();
                    break;
                }
                ++n;
            }
            if (lafClass == null) {
                look = look.toUpperCase();
                lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
                n2 = lookAndFeelInfoArray.length;
                n = 0;
                while (n < n2) {
                    info = lookAndFeelInfoArray[n];
                    if (info.getName().toUpperCase().contains(look)) {
                        lafClass = info.getClassName();
                        break;
                    }
                    ++n;
                }
            }
        }
        if (lafClass != null) {
            if (metalTheme != null) {
                if (metalTheme.equalsIgnoreCase("Steel")) {
                    MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                } else if (metalTheme.equalsIgnoreCase("Ocean")) {
                    MetalLookAndFeel.setCurrentTheme(new OceanTheme());
                }
            }
            UIManager.setLookAndFeel(lafClass);
            JFrame.setDefaultLookAndFeelDecorated(true);
        }
    }

    public Main(Computer comp, ComputerView view, MachineImage image) {
        this.computer = comp;
        this.computerView = view;
        Image icon = Toolkit.getDefaultToolkit().createImage(Main.class.getResource("icon/uk101-32.png"));
        this.frame = new JFrame(String.valueOf(this.computer.name) + " Simulation (v" + this.computer.version + ")");
        this.frame.setDefaultCloseOperation(2);
        this.frame.setIconImage(icon);
        this.frame.setContentPane(view);
        try {
            Class<?> ac = Class.forName("com.apple.eawt.Application");
            Method ga = ac.getMethod("getApplication", new Class[0]);
            Method si = ac.getMethod("setDockIconImage", Image.class);
            Image icon48 = Toolkit.getDefaultToolkit().createImage(Main.class.getResource("icon/uk101-48.png"));
            si.invoke(ga.invoke(null, new Object[0]), icon48);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                Main.this.computer.start();
            }

            public void windowClosed(WindowEvent e) {
                Main.this.computer.shutdown();
                System.exit(0);
            }
        });
        this.layout = view.defaultLayout();
        if (image != null) {
            this.layout = image.apply(this.computer, view);
        }
    }

    public void run() {
        if (!this.layout) {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            this.frame.pack();
            this.frame.setLocation((screen.width - this.frame.getWidth()) / 2, (screen.height - this.frame.getHeight()) / 2);
        }
        this.frame.setVisible(true);
        this.computerView.focusKeyboard();
    }
}

